//
//  OPAppStoreReceipt.h
//  ApplicationFrameworks
//
//  Created by Roustem Karimov on 2014-07-24.
//
//

#import <Foundation/Foundation.h>

@class OPAppStoreInAppPurchase;

@interface OPAppStoreReceipt : NSObject

@property (nonatomic, readonly) NSURL *receiptURL;

@property (nonatomic, readonly) NSString *originalDownloadVersion;
@property (nonatomic, readonly) NSString *originalDownloadDate;
@property (nonatomic, readonly) NSArray *inAppPurchases;

@property (nonatomic, readonly) NSData *machineGUIDData;

+ (NSURL *)demoReceiptURL;
+ (NSData *)demoReceiptMachineGUID;
+ (NSString *)demoReceiptBundleIdentifier;
+ (NSString *)demoReceiptBundleVersion;

- (instancetype)initWithReceiptURL:(NSURL *)receiptURL;
- (BOOL)verifyWithBundleIdentifier:(NSString *)bundleIdentifier bundleVersion:(NSString *)bundleVersion guidDataOrNil:(NSData *)guidDataOrNil;

#if !TARGET_OS_IPHONE
- (void)copyToSharedDirectoryIfNeeded;
#endif

- (OPAppStoreInAppPurchase *)inAppPurchaseWithProductId:(NSString *)productId;

@end
